/*
 * Decompiled with CFR 0.152.
 */
package adql.db.exception;

import adql.db.exception.UnresolvedColumnException;
import adql.db.exception.UnresolvedFunctionException;
import adql.db.exception.UnresolvedTableException;
import adql.parser.ParseException;
import java.util.ArrayList;
import java.util.Iterator;

public class UnresolvedIdentifiersException
extends ParseException
implements Iterable<ParseException> {
    private static final long serialVersionUID = 1L;
    protected ArrayList<ParseException> exceptions = new ArrayList();
    private String unresolvedIdentifiers = null;

    public final void addException(ParseException parseException) {
        if (parseException != null) {
            this.exceptions.add(parseException);
            if (parseException instanceof UnresolvedColumnException) {
                String string = ((UnresolvedColumnException)parseException).getColumnName();
                if (string != null && !string.trim().isEmpty()) {
                    this.addIdentifierName(string + " " + parseException.getPosition());
                }
            } else if (parseException instanceof UnresolvedTableException) {
                String string = ((UnresolvedTableException)parseException).getTableName();
                if (string != null && !string.trim().isEmpty()) {
                    this.addIdentifierName(string + " " + parseException.getPosition());
                }
            } else if (parseException instanceof UnresolvedFunctionException) {
                String string;
                String string2 = string = ((UnresolvedFunctionException)parseException).getFunction() == null ? null : ((UnresolvedFunctionException)parseException).getFunction().getName() + "(...)";
                if (string != null && !string.trim().isEmpty()) {
                    this.addIdentifierName(string);
                }
            } else if (parseException instanceof UnresolvedIdentifiersException) {
                this.addIdentifierName(((UnresolvedIdentifiersException)parseException).unresolvedIdentifiers);
            }
        }
    }

    private final void addIdentifierName(String string) {
        if (string != null && !string.trim().isEmpty()) {
            this.unresolvedIdentifiers = this.unresolvedIdentifiers == null ? "" : this.unresolvedIdentifiers + ", ";
            this.unresolvedIdentifiers = this.unresolvedIdentifiers + string;
        }
    }

    public final int getNbErrors() {
        return this.exceptions.size();
    }

    public final Iterator<ParseException> getErrors() {
        return this.exceptions.iterator();
    }

    @Override
    public final Iterator<ParseException> iterator() {
        return this.getErrors();
    }

    @Override
    public String getMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.exceptions.size()).append(" unresolved identifiers").append(this.unresolvedIdentifiers != null ? ": " + this.unresolvedIdentifiers : "").append('!');
        for (ParseException parseException : this.exceptions) {
            stringBuffer.append("\n  - ").append(parseException.getMessage());
        }
        return stringBuffer.toString();
    }
}

